/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.PointD;
import cds.aladin.ViewSimple;
import cds.aladin.prop.PropPanel;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.image.ColorModel;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FramePixelToolbox
extends JFrame {
    protected Aladin aladin;
    private static final int[] W = new int[]{100, 100, 50, 75, 25};
    private PixelLine pVal;
    private PixelLine pCutMin;
    private PixelLine pCutMax;
    private PixelLine pDataMin;
    private PixelLine pDataMax;
    private PixelLine pMin;
    private PixelLine pMax;
    private JTextField bzeroField;
    private JTextField bscaleField;
    private JTextField bitpixField;
    private JTextField blankField;
    private double raw;
    private int bitpix = 0;
    private double bzero = 0.0;
    private double bscale = 1.0;
    private double blank = Double.NaN;
    private double cutMin;
    private double cutMax;
    private double dataMin;
    private double dataMax;
    private ColorModel cm;
    private boolean isTransparent;

    protected FramePixelToolbox(Aladin aladin) {
        this.aladin = aladin;
        Aladin.setIcon(this);
        this.setTitle(Aladin.chaine.getString("PIXELTOOL"));
        this.enableEvents(64L);
        Util.setCloseShortcut(this, true, aladin);
        this.setLocation(Aladin.computeLocation(this));
        this.getContentPane().add((Component)this.createPanelTop(), "North");
        this.getContentPane().add((Component)this.createPanelBottom(), "South");
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.aladin.framePixelTool = null;
        }
        super.processWindowEvent(e);
    }

    private JPanel createPanelTop() {
        PixelLine pl;
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        c.anchor = 17;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        p.setLayout(g);
        JPanel p1 = new JPanel(new FlowLayout(3, 0, 0));
        p1.add(new MyLabel("Physical", "Physical value associated to the raw pixel value", W[0]));
        p1.add(new MyLabel("Raw", "Encoded pixel value", W[1]));
        p1.add(new MyLabel("IndexCM", "Index in the color map (normalized in [cutMin..cutMax])", W[2]));
        p1.add(new MyLabel("R G B", "Color map Red,Green,Blue components", W[3]));
        p1.add(new MyLabel("Color", "Displayed color", W[4]));
        PropPanel.addCouple(p, "", p1, g, c);
        this.pMin = pl = new PixelLine("Min enc.", "Smallest encodable value", false, false);
        PropPanel.addCouple(p, pl.label, pl.getPanel(), g, c);
        this.pDataMin = pl = new PixelLine("Data min", "Smallest value in the image", false, true);
        PropPanel.addCouple(p, pl.label, pl.getPanel(), g, c);
        this.pCutMin = pl = new PixelLine("Cut min", "Smallest displayed value", false, true);
        PropPanel.addCouple(p, pl.label, pl.getPanel(), g, c);
        this.pVal = pl = new PixelLine("Pixel value", "Pixel value", true, true);
        PropPanel.addCouple(p, pl.label, pl.getPanel(), g, c);
        this.pCutMax = pl = new PixelLine("Cut max", "Largest displayed value", false, true);
        PropPanel.addCouple(p, pl.label, pl.getPanel(), g, c);
        this.pDataMax = pl = new PixelLine("Data max", "Largest value in the image", false, true);
        PropPanel.addCouple(p, pl.label, pl.getPanel(), g, c);
        this.pMax = pl = new PixelLine("Max enc.", "Largest encodable value", false, false);
        PropPanel.addCouple(p, pl.label, pl.getPanel(), g, c);
        return p;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(459, super.getPreferredSize().height);
    }

    private JPanel createPanelBottom() {
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)this.createPanelBottomLeft(), "West");
        p.add((Component)this.createPanelBottomRight(), "East");
        return p;
    }

    private JPanel createPanelBottomRight() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        c.anchor = 17;
        c.gridwidth = 0;
        c.insets = new Insets(2, 2, 2, 2);
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 20));
        p.setLayout(g);
        this.bitpixField = new JTextField(10);
        this.bitpixField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FramePixelToolbox.this.modify(-1);
            }
        });
        this.blankField = new JTextField(10);
        this.blankField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FramePixelToolbox.this.modify(-1);
            }
        });
        PropPanel.addCouple(p, new JLabel("BITPIX"), this.bitpixField, g, c);
        PropPanel.addCouple(p, new JLabel("BLANK"), this.blankField, g, c);
        return p;
    }

    private JPanel createPanelBottomLeft() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        c.anchor = 17;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEmptyBorder(10, 20, 5, 5));
        p.setLayout(g);
        this.bzeroField = new JTextField(10);
        this.bzeroField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FramePixelToolbox.this.modify(-1);
            }
        });
        this.bscaleField = new JTextField(10);
        this.bscaleField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FramePixelToolbox.this.modify(-1);
            }
        });
        PropPanel.addCouple(p, new JLabel("BZERO"), this.bzeroField, g, c);
        PropPanel.addCouple(p, new JLabel("BSCALE"), this.bscaleField, g, c);
        return p;
    }

    private void modify(int from) {
        try {
            if (this.bzeroField.getText().length() > 0) {
                this.bzero = Double.parseDouble(this.bzeroField.getText());
            }
            if (this.bscaleField.getText().length() > 0) {
                this.bscale = Double.parseDouble(this.bscaleField.getText());
            }
            if (this.blankField.getText().length() > 0) {
                this.blank = this.blankField.getText().equalsIgnoreCase("NaN") ? Double.NaN : Double.parseDouble(this.blankField.getText());
            }
            if (from == 1) {
                this.raw = Double.parseDouble(this.pVal.field[from].getText());
                this.cutMin = Double.parseDouble(this.pCutMin.field[from].getText());
                this.cutMax = Double.parseDouble(this.pCutMax.field[from].getText());
                this.dataMin = Double.parseDouble(this.pDataMin.field[from].getText());
                this.dataMax = Double.parseDouble(this.pDataMax.field[from].getText());
            } else if (from == 0) {
                this.raw = (Double.parseDouble(this.pVal.field[from].getText()) - this.bzero) / this.bscale;
                this.cutMin = (Double.parseDouble(this.pCutMin.field[from].getText()) - this.bzero) / this.bscale;
                this.cutMax = (Double.parseDouble(this.pCutMax.field[from].getText()) - this.bzero) / this.bscale;
                this.dataMin = (Double.parseDouble(this.pDataMin.field[from].getText()) - this.bzero) / this.bscale;
                this.dataMax = (Double.parseDouble(this.pDataMax.field[from].getText()) - this.bzero) / this.bscale;
            }
            if (this.bitpixField.getText().length() > 0) {
                this.bitpix = (int)Double.parseDouble(this.bitpixField.getText());
                this.bitpix = this.bitpix / 8 * 8;
                if (Math.abs(this.bitpix) > 64) {
                    throw new Exception();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.resume();
    }

    protected void setPixel(ViewSimple v, double x, double y) {
        double pixel;
        PlanImage p = (PlanImage)v.pref;
        PointD po = v.getPosition(x, y);
        if (p instanceof PlanBG) {
            p.projd = v.projLocal.copy();
            pixel = ((PlanBG)p).getPixelInDouble(po.x, po.y);
        } else {
            int yi = (int)Math.floor(po.y);
            int xi = (int)Math.floor(po.x);
            if (yi < 0 || yi >= p.naxis2 || xi < 0 || xi > p.naxis1) {
                pixel = Double.NaN;
            } else if (p.pixelsOrigin != null) {
                pixel = p.getPixVal(p.pixelsOrigin, p.bitpix, (p.naxis2 - yi - 1) * p.naxis1 + xi) * p.bScale + p.bZero;
            } else {
                byte[] onePixelOrigin;
                if (!p.pixelsOriginFromDisk()) {
                    pixel = Double.NaN;
                }
                pixel = !p.getOnePixelFromCache(onePixelOrigin = new byte[p.npix], p.npix, xi, yi) ? Double.NaN : p.getPixVal(onePixelOrigin, this.bitpix, 0) * p.bScale + p.bZero;
            }
        }
        this.setParams(p, pixel);
    }

    protected void setParams(PlanImage p, double pixel) {
        this.bzero = p.bZero;
        this.bscale = p.bScale;
        this.blank = p.isBlank ? p.blank : Double.NaN;
        this.bitpix = p.bitpix;
        this.raw = pixel == this.blank ? this.blank : (pixel - this.bzero) / this.bscale;
        this.cutMin = p.pixelMin;
        this.cutMax = p.pixelMax;
        this.dataMin = p.dataMin;
        this.dataMax = p.dataMax;
        this.isTransparent = p.isTransparent();
        this.cm = p.getCM();
        this.resume();
    }

    private void resume() {
        if (this.pVal == null) {
            return;
        }
        this.pVal.setValue(this.raw);
        this.pCutMin.setValue(this.cutMin);
        this.pCutMax.setValue(this.cutMax);
        this.pDataMin.setValue(this.dataMin);
        this.pDataMax.setValue(this.dataMax);
        this.bzeroField.setText(Util.myRound(this.bzero));
        this.bscaleField.setText(Util.myRound(this.bscale));
        this.bitpixField.setText(this.bitpix + "");
        this.blankField.setText(this.blank + "");
        this.pMin.setValue(this.dataMin);
        String min = this.bitpix == 0 ? "" : (this.bitpix == 8 ? "0" : (this.bitpix == 16 ? "-32768" : (this.bitpix == 32 ? "-2147483648" : (this.bitpix == 64 ? "-2^63" : (this.bitpix == -32 ? Util.myRound("-3.4028235E38", 2) : Util.myRound("-1.7976931348623157E308", 2))))));
        this.pMin.setValue(min, 1);
        if (this.bzero == 0.0 && this.bscale == 1.0) {
            this.pMin.setValue(min, 0);
        } else {
            String minp = this.bitpix == 0 ? "" : (this.bitpix == 8 ? "" + this.bzero : (this.bitpix == 16 ? Util.myRound("" + (-32768.0 * this.bscale + this.bzero), 2) : (this.bitpix == 32 ? Util.myRound("" + (-9.223372036854776E18 * this.bscale + this.bzero), 2) : (this.bitpix == 64 ? Util.myRound("" + (-Math.pow(2.0, 63.0) * this.bscale + this.bzero), 2) : (this.bitpix == -32 ? Util.myRound("" + (-3.4028234663852886E38 * this.bscale + this.bzero), 2) : Util.myRound("" + (-1.7976931348623157E308 * this.bscale + this.bzero), 2))))));
            this.pMin.setValue(minp, 0);
        }
        this.pMax.setValue(this.dataMax);
        String max = this.bitpix == 0 ? "" : (this.bitpix == 8 ? "255" : (this.bitpix == 16 ? "32767" : (this.bitpix == 32 ? "2147483647" : (this.bitpix == 64 ? "2^63" : (this.bitpix == -32 ? Util.myRound("3.4028235E38", 2) : Util.myRound("1.7976931348623157E308", 2))))));
        this.pMax.setValue(max, 1);
        if (this.bzero == 0.0 && this.bscale == 1.0) {
            this.pMax.setValue(max, 0);
        } else {
            String maxp = this.bitpix == 0 ? "" : (this.bitpix == 8 ? "" + (255.0 * this.bscale + this.bzero) : (this.bitpix == 16 ? Util.myRound("" + (32767.0 * this.bscale + this.bzero), 2) : (this.bitpix == 32 ? Util.myRound("" + (9.223372036854776E18 * this.bscale + this.bzero), 2) : (this.bitpix == 64 ? Util.myRound("" + (Math.pow(2.0, 63.0) * this.bscale + this.bzero), 2) : (this.bitpix == -32 ? Util.myRound("" + (3.4028234663852886E38 * this.bscale + this.bzero), 2) : Util.myRound("" + (Double.MAX_VALUE * this.bscale + this.bzero), 2))))));
            this.pMax.setValue(maxp, 0);
        }
        this.aladin.glu.log("PixelToolbox", "");
    }

    class MyLabel
    extends JLabel {
        int width;

        MyLabel(String s, String tip, int w) {
            super(s, 0);
            this.width = 75;
            Util.toolTip(this, tip);
            this.width = w;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.width, super.getPreferredSize().height);
        }
    }

    class PixelLine {
        JLabel label;
        MyField[] field = new MyField[FramePixelToolbox.access$100().length];

        PixelLine(String label, String tip, boolean bold, boolean editable) {
            this.label = new JLabel(label);
            Util.toolTip(this.label, tip);
            if (bold) {
                this.label.setFont(this.label.getFont().deriveFont(1));
            }
            for (int i = 0; i < this.field.length; ++i) {
                MyField f = this.field[i] = new MyField(W[i]);
                if (i == 4) {
                    this.field[i].setOpaque(true);
                }
                f.setEditable(editable && i < 2);
                if (f.isEditable()) {
                    f.setActionCommand(i + "");
                    f.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            FramePixelToolbox.this.modify(Integer.parseInt(e.getActionCommand()));
                        }
                    });
                }
                if (!bold) continue;
                f.setFont(f.getFont().deriveFont(1));
            }
        }

        JPanel getPanel() {
            JPanel p = new JPanel(new FlowLayout(3, 0, 0));
            for (int i = 0; i < this.field.length; ++i) {
                p.add(this.field[i]);
            }
            return p;
        }

        void setValue(double raw) {
            this.field[0].setText(Double.isNaN(raw) || raw == FramePixelToolbox.this.blank ? "" : Util.myRound(raw * FramePixelToolbox.this.bscale + FramePixelToolbox.this.bzero));
            this.field[1].setText(Double.isNaN(raw) ? "NaN" : Util.myRound(raw));
            int index = this.getColormapIndex(raw);
            this.field[2].setText(index + "");
            if (FramePixelToolbox.this.cm != null) {
                int r = FramePixelToolbox.this.cm.getRed(index);
                int g = FramePixelToolbox.this.cm.getGreen(index);
                int b = FramePixelToolbox.this.cm.getBlue(index);
                this.field[3].setText(String.format("%02X-%02X-%02X", r, g, b));
                this.field[4].setBackground(new Color(r, g, b));
                this.field[4].setOpaque(true);
            } else {
                this.field[3].setText("");
                this.field[4].setBackground(Color.white);
            }
        }

        void setValue(String s, int i) {
            this.field[i].setText(s);
        }

        int getColormapIndex(double c) {
            int range = FramePixelToolbox.this.isTransparent ? 255 : 256;
            int gapTransp = FramePixelToolbox.this.isTransparent ? 1 : 0;
            double r = (double)range / (FramePixelToolbox.this.cutMax - FramePixelToolbox.this.cutMin);
            int pos = Double.isNaN(c) || c == FramePixelToolbox.this.blank ? 0 : gapTransp + (c <= FramePixelToolbox.this.cutMin ? 0 : (c >= FramePixelToolbox.this.cutMax ? --range : (int)((c - FramePixelToolbox.this.cutMin) * r)));
            return pos;
        }
    }

    class MyField
    extends JTextField {
        int width = 75;

        MyField(int w) {
            this.width = w;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.width, super.getPreferredSize().height);
        }
    }
}

